#!/bin/bash

function ParseDelimited() {   
   local result=$(cut -d ";" -f $2 <<< "$1") 
   echo "$result" | xargs  
   return 1 
}

function AddLog() {
   echo $(date '+%Y-%m-%d %H:%M:%S') $1 >> HpClient-update.log
}

pid=$(pidof $2)
if [ -z "$pid" ]; then
  AddLog "Proces $2 nebyl nalezen." 
else
  kill ${pid}
  AddLog "Proces $2 byl ukončen"
fi

File=$1
if ! [[ -f "$File" ]]
then
  AddLog "Chyba, řídící soubor pro aktualizaci nebyl nalezen"
  exit 1
fi

State=true;
Backup=()
while IFS='' read -r Line || [[ -n "${Line}" ]]; do   
  
   AppPath=$(ParseDelimited "$Line" 1)
   DownloadPath=$(ParseDelimited "$Line" 2)            
   if ! [ -f "$AppPath" ] || ! [ -f "$DownloadPath" ]; 
   then
     AddLog "Chyba, buď cílový, nebo stažený soubor neexistuje"
     exit 1 
   fi
  
   AddLog "Vytváří se záloha původního souboru"
   BackupPath="$AppPath.backup"
   Backup+=($BackupPath)
          
   if [ -f "$BackupPath" ]; 
   then 
     rm $BackupPath 
   fi 
   
   mv $AppPath $BackupPath
   if ! [ $? -eq 0 ]; 
   then
     AddLog "Chyba, nepodařilo se vytvořit zálohu souboru"
     State=false
   fi
   
   AddLog "Přesunutí stáhnutého souboru do požadovaného adresáře"
   mv $DownloadPath $AppPath
   if ! [ $? -eq 0 ]; 
   then
     AddLog "Chyba, nepodařilo se vytvořit zálohu souboru"
     State=false
   fi  
done < "$File"
if [ "$State" = true ]; then 
  rm -r $(dirname $DownloadPath)
  AddLog "Smazání zálohy" 
  for value in "${Backup[@]}"
   do     
     rm $value
   done    
  AddLog "Hotovo" 
else AddLog "Chyba, aktualizace se nezdařila" 
fi
